import {ReactNode} from 'react';
import _throttle from 'lodash/throttle';

import {EHotelsGoal} from 'utilities/metrika/types/goals/hotels';
import {SearchPageLayoutView} from 'types/hotels/search/ISearchLayout';

import {reachGoal} from 'utilities/metrika';
import scrollTo from 'utilities/dom/scrollTo';

import SearchPageMap from './components/SearchPageMap/SearchPageMap';
import ForceLogin from 'projects/hotels/components/ForceLogin/ForceLogin';

import BaseSearchPage from '../BaseSearchPage/BaseSearchPage';
import DesktopSearchPageLayout from '../DesktopSearchPageLayout/DesktopSearchPageLayout';

import cx from './DesktopSearchPage.scss';

const TOGGLE_BUTTON_CLICK_THROTTLE_TIME = 1000;

class DesktopSearchPage extends BaseSearchPage {
    private handleClickToggleViewButton = _throttle(() => {
        scrollTo({top: 0});
        this.toggleActiveView();

        reachGoal(EHotelsGoal.SEARCH_PAGE_MAP_VIEW_CHANGE);
    }, TOGGLE_BUTTON_CLICK_THROTTLE_TIME);

    private renderMap(): ReactNode {
        const {activeView} = this.state;
        const {windowHeight, changeFilterGroup} = this.props;
        const hasFullScreenMap = activeView === SearchPageLayoutView.MAP;

        return (
            <SearchPageMap
                windowHeight={windowHeight}
                hasFullScreenMap={hasFullScreenMap}
                onToggleMapView={this.handleClickToggleViewButton}
                renderHotelsMap={this.renderHotelsMap}
                onChangeFilterGroup={changeFilterGroup}
            />
        );
    }

    render(): ReactNode {
        const {hasMirBanner} = this.props;
        const {activeView} = this.state;
        const hasHotelList = activeView === SearchPageLayoutView.LIST;

        return (
            <DesktopSearchPageLayout
                className={cx('desktopSearchPage')}
                hideSearchInformation
            >
                {this.renderPreloadChunksControl()}
                {this.renderHotelsSearchController()}
                {this.renderSearchInformationProvider()}
                <DesktopSearchPageLayout.Content>
                    {hasHotelList && (
                        <DesktopSearchPageLayout.LeftColumn>
                            {this.renderSearchForm()}
                            {this.renderFilters()}
                            <div className={cx('hotelListAndMap')}>
                                <div
                                    className={cx('hotelListColumn', {
                                        hotelListColumn_onlySearchInformation:
                                            !hasHotelList,
                                    })}
                                >
                                    {hasMirBanner
                                        ? this.renderMirCashbackBanner(
                                              cx('banner'),
                                          )
                                        : this.renderAdFoxBanner(cx('banner'))}
                                    <ForceLogin
                                        className={cx('forceLogin')}
                                        isSearchPage
                                    />
                                    {this.renderHotelsList(cx('hotelList'))}
                                </div>
                            </div>
                            {this.renderSearchNavigationButtons()}
                            <div className={cx('disclaimer')}>
                                {this.renderPromoDisclaimer()}
                            </div>
                        </DesktopSearchPageLayout.LeftColumn>
                    )}

                    <DesktopSearchPageLayout.RightColumn
                        noScroll={!hasHotelList}
                        withLargeMap={!hasHotelList}
                        stickToTop
                    >
                        {this.renderMap()}
                    </DesktopSearchPageLayout.RightColumn>
                </DesktopSearchPageLayout.Content>
            </DesktopSearchPageLayout>
        );
    }
}

export default DesktopSearchPage;
