import React from 'react';
import {useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';

import {getMapBoundsBySearch} from 'selectors/hotels/search/map/getMapBoundsBySearch';

import * as i18nBlock from 'i18n/hotels-SearchPage';

import YandexReadonlyMaps from 'components/YandexReadonlyMaps/YandexReadonlyMaps';
import Button from 'components/Button/Button';
import Skeleton from 'components/Skeletons/Skeleton/Skeleton';
import LocationIcon from 'icons/16/Location';

import cx from './MapSnippet.scss';

interface IMapSnippetProps extends IWithClassName {
    renderMapsComponent: boolean;

    onClick(): void;
}

const LOCATION_ICON = <LocationIcon />;

const MapSnippet: React.FC<IMapSnippetProps> = props => {
    const {className, renderMapsComponent, onClick} = props;

    const mapBounds = useSelector(getMapBoundsBySearch);

    if (!mapBounds) {
        return (
            <div className={cx('root', className)}>
                <Skeleton className={cx('mapSkeleton')} />
            </div>
        );
    }

    return (
        <div className={cx('root', className)} onClick={onClick}>
            <div className={cx('mapContainer')}>
                {renderMapsComponent && (
                    <YandexReadonlyMaps
                        defaultBounds={mapBounds}
                        hideCopyright
                    />
                )}
            </div>

            <Button
                className={cx('toggleViewButton')}
                theme="raised"
                iconLeft={LOCATION_ICON}
            >
                {i18nBlock.viewOnMap()}
            </Button>
        </div>
    );
};

export default React.memo(MapSnippet);
