import React, {useMemo} from 'react';

import {IWithClassName} from 'src/types/withClassName';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import Button from 'components/Button/Button';
import FullscreenIcon from 'icons/16/Fullscreen';
import ExitFullscreenIcon from 'icons/16/ExitFullscreen';

export interface IToggleViewButtonProps extends IWithClassName {
    canToggleToFullView: boolean;

    onClick(): void;
}

const ToggleMapViewButton: React.FC<IToggleViewButtonProps> = ({
    onClick,
    canToggleToFullView,
}) => {
    const icon = useMemo<React.ReactNode>(() => {
        if (canToggleToFullView) {
            return <FullscreenIcon />;
        }

        return <ExitFullscreenIcon />;
    }, [canToggleToFullView]);

    return (
        <Button
            onClick={onClick}
            theme="raised"
            shape="circle"
            {...prepareQaAttributes('hotels-searchPage-map-toggleViewButton')}
        >
            {icon}
        </Button>
    );
};

export default ToggleMapViewButton;
