import React, {ReactElement, ReactNode} from 'react';

import {EProjectName} from 'constants/common';

import {EFooterProject} from 'components/Footer/types';
import {IWithClassName} from 'types/withClassName';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import Footer from 'components/Footer/Footer';
import LayoutDefault from 'components/Layouts/LayoutDefault/LayoutDefault';
import StickyColumn, {
    IStickyColumnProps,
} from './components/StickyColumn/StickyColumn';

import cx from './DesktopSearchPageLayout.scss';

interface ISearchPageLayoutProps extends IWithClassName {
    children: ReactNode;
    canShowHeader?: boolean;
    canShowFooter?: boolean;
    hideSearchInformation?: boolean;
}

const Filters: React.FC = ({children}) => (
    <div className={cx('filters')}>{children}</div>
);

const Content: React.FC = ({children}) => (
    <div className={cx('content')}>{children}</div>
);

const LeftColumn: React.FC = ({children}) => (
    <div className={cx('leftColumn')}>
        {children}

        <Footer
            project={EProjectName.HOTELS}
            footerType={EFooterProject.HOTELS}
            wrapperClassName={cx('footer')}
            {...prepareQaAttributes('portalFooter')}
        />
    </div>
);

interface IRightColumnProps extends IStickyColumnProps {
    withLargeMap: boolean;
    stickToTop?: boolean;
}

const RightColumn: React.FC<IRightColumnProps> = props => {
    const {className, withLargeMap, stickToTop, ...rest} = props;

    return (
        <StickyColumn
            className={cx('rightColumn', className, {
                rightColumn_withLargeMap: withLargeMap,
            })}
            stickToTop={stickToTop}
            {...rest}
        />
    );
};

const DesktopSearchPageLayout = (
    props: ISearchPageLayoutProps,
): ReactElement => (
    <LayoutDefault
        className={cx('root')}
        headerWrapperClassName={cx('headerWrapper')}
        formWrapperClassName={cx('formWrapper')}
        isFixedNavigation
        hasSideSheetNavigation
        showNavigation
        showHeader={props.canShowHeader}
        showFooter={false}
        searchFormInitialIsExpanded={false}
        project={EProjectName.HOTELS}
        hideSearchInformation={props.hideSearchInformation}
    >
        {props.children}
    </LayoutDefault>
);

DesktopSearchPageLayout.Filters = Filters;
DesktopSearchPageLayout.Content = Content;
DesktopSearchPageLayout.LeftColumn = LeftColumn;
DesktopSearchPageLayout.RightColumn = RightColumn;

export default DesktopSearchPageLayout;
