import React from 'react';

/* Types */
import {IWithClassName} from 'types/withClassName';

/* Components */
interface IHotelSearchCardOfferSkeletonProps extends IWithClassName {}

/* Init styles */
import cx from './HotelSearchCardOfferSkeleton.scss';

const HotelSearchCardOfferSkeleton = (
    props: IHotelSearchCardOfferSkeletonProps,
): React.ReactElement => (
    <section className={cx('mainOffer', props.className)}>
        <div className={cx('offer')}>
            <div className={cx('offerPrice', 'hotelBaseElement')} />
            <div className={cx('offerLink', 'hotelBaseElement')} />
        </div>
        <div className={cx('offerMeal', 'hotelBaseElement')} />
    </section>
);

export default HotelSearchCardOfferSkeleton;
