/* Types */
import {IWithClassName} from 'types/withClassName';

/* Components */
interface IHotelSearchCardSkeleton extends IWithClassName {}

/* Init styles */
import cx from './HotelSearchCardSkeleton.scss';

const HotelSearchCardSkeleton = (props: IHotelSearchCardSkeleton) => (
    <section className={cx('hotelCard', props.className)}>
        <div className={cx('image')} />
        <div className={cx('content')}>
            <div className={cx('hotelInfo')}>
                <div className={cx('hotelName', 'hotelBaseElement')} />
                <div className={cx('hotelAddress', 'hotelBaseElement')} />
                <div className={cx('hotelNearestMetro', 'hotelBaseElement')} />
                <div className={cx('hotelRating', 'hotelBaseElement')} />
                <div className={cx('hotelAmenity', 'hotelBaseElement')} />
            </div>
            <div className={cx('mainOffer')}>
                <div className={cx('offer')}>
                    <div className={cx('offerPrice', 'hotelBaseElement')} />
                    <div className={cx('offerLink', 'hotelBaseElement')} />
                </div>
                <div className={cx('offerMeal', 'hotelBaseElement')} />
                <div className={cx('offerCancellation', 'hotelBaseElement')} />
            </div>
        </div>
    </section>
);

export default HotelSearchCardSkeleton;
