import React from 'react';
import {useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';
import {PermalinkType} from 'types/hotels/hotel/IHotel';
import {IActiveHotel} from 'types/hotels/hotel/IActiveHotel';

import {hotelsListSelector} from 'projects/hotels/pages/SearchPage/components/HotelsList/selectors/hotelsListSelector';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import CommonHotelsList from 'projects/hotels/components/HotelsList/HotelsList';

interface IHotelsListProps extends IWithClassName, IWithQaAttributes {
    onHoverHotelCard(permalink: IActiveHotel | undefined): void;
    onLeaveHotelCard(): void;
    onFavoriteClick?({
        permalink,
        isFavorite,
    }: {
        permalink: PermalinkType;
        isFavorite: boolean;
    }): void;
    onCloseModalClick?(): void;
}

const HotelsList: React.FC<IHotelsListProps> = props => {
    const {
        className,
        onHoverHotelCard,
        onLeaveHotelCard,
        onFavoriteClick,
        onCloseModalClick,
    } = props;

    const {
        hotels,
        nights,
        hotelWithOffersByPermalink,
        offerSearchParams,
        searchIsFinished,
        withTopHotel,
        activeHotelPermalink,
    } = useSelector(hotelsListSelector);

    const deviceType = useDeviceType();

    return (
        <CommonHotelsList
            className={className}
            hotels={hotels}
            hotelWithOffersByPermalink={hotelWithOffersByPermalink}
            offerRequestParams={offerSearchParams}
            nights={nights}
            searchIsFinished={searchIsFinished}
            onHoverHotelCard={onHoverHotelCard}
            onLeaveHotelCard={onLeaveHotelCard}
            activeHotelPermalink={activeHotelPermalink}
            withTopHotel={withTopHotel}
            deviceType={deviceType}
            onFavoriteClick={onFavoriteClick}
            onCloseModalClick={onCloseModalClick}
            currentPage="search"
            {...prepareQaAttributes(props)}
        />
    );
};

export default React.memo(HotelsList);
