import {getHotelList} from 'selectors/hotels/search/hotelList/getHotelList';
import {textSearchInformationSelector} from 'selectors/hotels/search/searchInformation/textSearchInformationSelector';
import {getSearchInfo} from 'selectors/hotels/search/searchHotels/getSearchInfo';
import {getActiveHotelPermalink} from 'selectors/hotels/search/selection/getActiveHotelPermalink';

import createTypedStructuredSelector from 'src/redux/utilities/createTypedStructuredSelector';

export const hotelsListSelector = createTypedStructuredSelector({
    hotels: state => getHotelList(state).hotels,
    nights: state => textSearchInformationSelector(state).nights,
    hotelWithOffersByPermalink: state =>
        getSearchInfo(state).data?.hotelWithOffersByPermalink,
    offerSearchParams: state => getSearchInfo(state).data?.offerSearchParams,
    searchIsFinished: state => {
        const {data, isLoading} = getSearchInfo(state);

        return data?.offerSearchProgress.finished && !isLoading;
    },
    withTopHotel: state => Boolean(getSearchInfo(state).data?.topHotelSlug),
    activeHotelPermalink: getActiveHotelPermalink,
});
