import {
    getHotelsCurrentFilters,
    getHotelsFilters,
    getHotelsPermanentFilters,
} from 'selectors/hotels/search/filters/hotelsFiltersSelector';
import {getSortInfo} from 'selectors/hotels/search/sort/getSortInfo';
import {getHotelList} from 'selectors/hotels/search/hotelList/getHotelList';
import {getSearchInfo} from 'selectors/hotels/search/searchHotels/getSearchInfo';
import {getMap} from 'selectors/hotels/search/map/getMap';
import {getMapBoundsBySearch} from 'selectors/hotels/search/map/getMapBoundsBySearch';

import createTypedStructuredSelector from 'src/redux/utilities/createTypedStructuredSelector';

export const searchControllerSelector = createTypedStructuredSelector({
    currentFilters: getHotelsCurrentFilters,
    permanentFilters: getHotelsPermanentFilters,
    needSyncCurrentFiltersWithServer: state =>
        getHotelsFilters(state).needSyncCurrentFiltersWithServer,
    needSyncPermanentFiltersWithServer: state =>
        getHotelsFilters(state).needSyncPermanentFiltersWithServer,
    needSyncSortWithServer: state => getSortInfo(state).needSyncSortWithServer,
    navigationTokens: state => getHotelList(state).navigationTokens,
    navigationToken: state => getHotelList(state).navigationToken,
    offerSearchParams: state => getSearchInfo(state).data?.offerSearchParams,
    mapBounds: state => getMap(state).mapBounds,
    mapBoundsBySearch: getMapBoundsBySearch,
    isSearchFinished: state =>
        getSearchInfo(state).data?.offerSearchProgress.finished,
    geoId: state => getSearchInfo(state).data?.searchRegion.geoId,
    lastSearchTimestamp: state => getSearchInfo(state).lastSearchTimestamp,
    sortOrigin: state => {
        const {sortInfo, sortOrigin} = getSortInfo(state);

        return sortInfo?.sortOrigin || sortOrigin;
    },
    topHotelSlug: state => getSearchInfo(state).data?.topHotelSlug,
});
