import {ReactRouterLocationType} from 'types/common/IReactRouterLocation';
import {
    IBaseSearchQueryParams,
    ISearchPageGeolocationQueryParams,
    ISearchPageGeoQueryParams,
} from 'types/hotels/common/IQueryParams';

import {
    getSearchPageQueryByInfo,
    ISearchPageInfoForQuery,
} from 'projects/hotels/utilities/getSearchPageQueryByInfo/getSearchPageQueryByInfo';
import getQueryByLocation from 'utilities/getQueryByLocation/getQueryByLocation';

const CHECK_SEARCH_PARAM_LIST: (keyof (IBaseSearchQueryParams &
    ISearchPageGeoQueryParams &
    ISearchPageGeolocationQueryParams))[] = [
    'geoId',
    'checkinDate',
    'checkoutDate',
    'adults',
    'childrenAges',
    'sortOrigin',
];

export const checkDifferenceBetweenQueryAndSearchInfoParams = (
    location: ReactRouterLocationType,
    searchInfo: ISearchPageInfoForQuery,
): boolean => {
    const queryBySearchInfo = getSearchPageQueryByInfo(searchInfo);
    const queryByLocation = getQueryByLocation(location);

    return !CHECK_SEARCH_PARAM_LIST.every(paramKey => {
        if (!queryByLocation[paramKey] && !queryBySearchInfo[paramKey]) {
            return true;
        }

        const convertedQueryBySearchInfo = String(queryBySearchInfo[paramKey]);

        return queryByLocation[paramKey] === convertedQueryBySearchInfo;
    });
};
