import React from 'react';

import {IHotelWithOffers} from 'types/hotels/hotel/IHotelWithOffers';
import {IRequiredOfferParams} from 'types/hotels/offer/IHotelOffer';
import {PermalinkType} from 'types/hotels/hotel/IHotel';

import MobileMapHotelSnippet from 'projects/hotels/pages/SearchPage/components/HotelsSearchMap/components/MobileMapHotelSnippet/MobileMapHotelSnippet';
import MobileSnippetModal from 'projects/hotels/pages/SearchPage/components/HotelsSearchMap/components/MobileSnippetModal/MobileSnippetModal';

interface IMobileMapHotelCardProps {
    className?: string;
    hotelWithOffers?: IHotelWithOffers;
    nights: number;
    offerRequestParams?: IRequiredOfferParams;

    onFavoriteClick?({
        permalink,
        isFavorite,
    }: {
        permalink: PermalinkType;
        isFavorite: boolean;
    }): void;
}

const MobileMapHotelCard: React.FC<IMobileMapHotelCardProps> = props => {
    const {hotelWithOffers, nights, offerRequestParams, onFavoriteClick} =
        props;

    // FYI: MobileSnippetModal должен рендерится всегда,
    // Если заменить на if(!hotelWithOffers) return null
    // Анимация работать не будет

    return (
        <MobileSnippetModal>
            {hotelWithOffers && (
                <MobileMapHotelSnippet
                    isFavorite={hotelWithOffers.hotel.isFavorite}
                    nights={nights}
                    offerRequestParams={offerRequestParams}
                    hotelWithOffers={hotelWithOffers}
                    onFavoriteClick={onFavoriteClick}
                />
            )}
        </MobileSnippetModal>
    );
};

export default MobileMapHotelCard;
