import React from 'react';
import {useTransition, animated, UseTransitionProps} from 'react-spring';

import cx from './MobileSnippetModal.scss';

const DURATION = 120;

const TRANSITION_PARAMS: UseTransitionProps = {
    from: {opacity: 0},
    keys: content => Boolean(content).toString(),
    enter: {opacity: 1},
    leave: {opacity: 0},
    config: {duration: DURATION},
};

const MobileSnippetModal: React.FC = ({children}) => {
    const transition = useTransition(children, TRANSITION_PARAMS);

    return transition(
        (style, content) =>
            content && (
                <animated.div className={cx('root')} style={style}>
                    {content}
                </animated.div>
            ),
    );
};

export default MobileSnippetModal;
