import {FunctionComponent, useMemo, useEffect} from 'react';

import {useTimeout} from 'utilities/hooks/useTimeout';
import {useBoolean} from 'utilities/hooks/useBoolean';

import * as i18nBlock from 'i18n/hotels-HotelsMap';

import Snackbar from 'components/Snackbar/Snackbar';

import cx from './NoResultsMessage.scss';

const HIDE_TIMEOUT = 5000;

interface INoResultsMessageProps {
    noResults: boolean;
    totalActiveFilters: number;
}

const NoResultsMessage: FunctionComponent<INoResultsMessageProps> = ({
    noResults,
    totalActiveFilters,
}) => {
    const {value: isVisible, setTrue: show, setFalse: hide} = useBoolean(false);
    const message = useMemo(() => {
        if (totalActiveFilters > 0) {
            return i18nBlock.noResultsTryResetFiltersOrChangeMapScale();
        }

        return i18nBlock.noResultsTryResetFilters();
    }, [totalActiveFilters]);
    const hideByTimeout = useTimeout(hide, HIDE_TIMEOUT);

    useEffect(() => {
        if (noResults) {
            show();
            hideByTimeout();
        } else {
            hide();
        }
    }, [noResults]);

    return (
        <Snackbar className={cx('noResultsMessage')} isVisible={isVisible}>
            <span
                dangerouslySetInnerHTML={{
                    __html: message,
                }}
            />
        </Snackbar>
    );
};

export default NoResultsMessage;
