import {EToggleSize} from 'components/Toggle/types';

import * as i18nBlock from 'i18n/hotels-HotelsMap';

import Toggle from 'components/Toggle/Toggle';
import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';

import cx from './RegionToggle.scss';

export interface IRegionToggleProps {
    geoLabel: string;

    isActive: boolean;
    onToggle: () => void;
}

const RegionToggle: React.FC<IRegionToggleProps> = ({
    geoLabel,
    isActive,
    onToggle,
}) => (
    <Flex
        className={cx('root')}
        alignItems="center"
        justifyContent="center"
        inline
        between="2"
        onClick={onToggle}
    >
        <Toggle size={EToggleSize.XS} isActive={isActive} />
        <Text>{i18nBlock.onlyGeo({name: geoLabel})}</Text>
    </Flex>
);

export default RegionToggle;
