import {getMap} from 'selectors/hotels/search/map/getMap';
import {getSearchInfo} from 'selectors/hotels/search/searchHotels/getSearchInfo';
import {textSearchInformationSelector} from 'selectors/hotels/search/searchInformation/textSearchInformationSelector';
import {getActiveHotelPermalink} from 'selectors/hotels/search/selection/getActiveHotelPermalink';
import {getActiveHotelSource} from 'selectors/hotels/search/selection/getActiveHotelSource';
import deviceTypeSelector from 'selectors/common/deviceTypeSelector';
import {getMapBoundsBySearch} from 'selectors/hotels/search/map/getMapBoundsBySearch';
import experimentsSelector from 'selectors/common/experimentsSelector';
import {getTotalActiveFilters} from 'selectors/hotels/search/filters/getTotalActiveFilters';
import {getHotelsPermanentFilters} from 'selectors/hotels/search/filters/hotelsFiltersSelector';

import createTypedStructuredSelector from 'src/redux/utilities/createTypedStructuredSelector';

export const searchMapSelector = createTypedStructuredSelector({
    hotels: state => getMap(state).hotels,
    hotelWithOffersByPermalink: state =>
        getSearchInfo(state).data?.hotelWithOffersByPermalink,
    nights: state => textSearchInformationSelector(state).nights,
    offerRequestParams: state => getSearchInfo(state).data?.offerSearchParams,
    isLoading: state => getSearchInfo(state).isLoading,
    isSearchFinished: state =>
        !getSearchInfo(state).isLoading &&
        getSearchInfo(state).data?.offerSearchProgress.finished,
    bboxAsStruct: getMapBoundsBySearch,
    withTopHotel: state => Boolean(getSearchInfo(state).data?.topHotelSlug),
    activeHotelPermalink: getActiveHotelPermalink,
    activeHotelSource: getActiveHotelSource,
    selectedMapMarkerPermalink: state =>
        getMap(state).selectedMapMarkerPermalink,
    viewedMapMarkerPermalinks: state => getMap(state).viewedMapMarkerPermalinks,
    deviceType: state => deviceTypeSelector(state),
    experiments: experimentsSelector,
    totalActiveFilters: getTotalActiveFilters,
    geoIdFilter: state => getHotelsPermanentFilters(state).geoIdFilter,
});
