/* Types */

import {ISize} from 'utilities/hooks/useElementSize';

export interface ICardPosition {
    left: number;
    top: number;
}

export interface IMarkerPosition extends ICardPosition {
    bottom: number;
}

/* Constants */
const CARD_OFFSET = 4;

export const calculateCardPosition = ({
    markerPosition,
    containerSize,
    cardSize,
}: {
    markerPosition: IMarkerPosition;
    containerSize: ISize;
    cardSize: ISize;
}): ICardPosition => {
    const {width, height} = cardSize;

    if (width && height) {
        const {left, top, bottom} = markerPosition;

        const resultLeft = Math.max(CARD_OFFSET, left - width / 2);
        let resultTop = Math.max(CARD_OFFSET, top - height - CARD_OFFSET);

        if (resultTop === CARD_OFFSET) {
            resultTop = bottom + CARD_OFFSET;
        }

        return {
            left: Math.min(
                resultLeft,
                containerSize.width - width - CARD_OFFSET,
            ),
            top: resultTop,
        };
    }

    return {
        left: CARD_OFFSET,
        top: CARD_OFFSET,
    };
};
