import React from 'react';

/* Types */
import {IWithClassName} from 'types/withClassName';

/* Components */
interface IMobileHotelSearchCardOfferSkeletonProps extends IWithClassName {}

/* Init styles */
import cx from './MobileHotelSearchCardOfferSkeleton.scss';

const MobileHotelSearchCardOfferSkeleton = (
    props: IMobileHotelSearchCardOfferSkeletonProps,
): React.ReactElement => (
    <section className={cx('offer', props.className)}>
        <div className={cx('offerOperator')}>
            <div className={cx('offerPrice', 'hotelBaseElement')} />
            <div className={cx('offerOperatorName', 'hotelBaseElement')} />
        </div>
        <div className={cx('offerLink', 'hotelBaseElement')} />
    </section>
);

export default MobileHotelSearchCardOfferSkeleton;
