import {ReactNode} from 'react';

import {EProjectName} from 'constants/common';

import {EFooterProject} from 'components/Footer/types';
import EHeaderBorderBottomType from 'components/Header/types/EHeaderBorderBottomType';

import LayoutDefault, {
    ELayoutBgColor,
} from 'components/Layouts/LayoutDefault/LayoutDefault';

interface ISearchPageLayoutProps {
    children: ReactNode;
    className?: string;
    canShowHeader?: boolean;
    canShowFooter?: boolean;
    hideSearchInformation?: boolean;
    searchFormCollapsedClassName?: string;
}

const MobileSearchPageLayout: React.FC<ISearchPageLayoutProps> = ({
    className,
    canShowHeader,
    canShowFooter,
    hideSearchInformation,
    searchFormCollapsedClassName,
    children,
}) => (
    <LayoutDefault
        bgColor={ELayoutBgColor.DARK}
        className={className}
        isFixedNavigation
        showSearchForm
        hasSideSheetNavigation
        showNavigation
        showHeader={canShowHeader}
        showFooter={canShowFooter}
        headerBorderBottomType={EHeaderBorderBottomType.NONE}
        searchFormInitialIsExpanded={false}
        project={EProjectName.HOTELS}
        footerType={EFooterProject.HOTELS}
        hideSearchInformation={hideSearchInformation}
        searchFormCollapsedClassName={searchFormCollapsedClassName}
    >
        {children}
    </LayoutDefault>
);

export default MobileSearchPageLayout;
