import {getHotelsCurrentFilters} from 'selectors/hotels/search/filters/hotelsFiltersSelector';
import {getSearchInfo} from 'selectors/hotels/search/searchHotels/getSearchInfo';
import {getTotalActiveFilters} from 'selectors/hotels/search/filters/getTotalActiveFilters';
import {getTotalNights} from 'selectors/hotels/search/searchHotels/getTotalNights';
import experimentsSelector from 'selectors/common/experimentsSelector';

import createTypedStructuredSelector from 'src/redux/utilities/createTypedStructuredSelector';

export const hotelsFiltersSelector = createTypedStructuredSelector({
    filters: getHotelsCurrentFilters,
    canDisableFilters: state => getSearchInfo(state).isLoading,
    experiments: experimentsSelector,
    nights: getTotalNights,
    totalActiveFilters: getTotalActiveFilters,
});

export type THotelsFilters = ReturnType<typeof hotelsFiltersSelector>;
