import React from 'react';

import {LEGAL_LINK} from 'projects/hotels/pages/TravellineOfferPage/utilities/constants';

import {
    getQa,
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/hotels-OfferPage';

import Text from 'components/Text/Text';
import Checkbox from 'components/Checkbox/Checkbox';
import Button from 'components/Button/Button';
import Link from 'components/Link/Link';

import cx from './OfferForm.scss';

const CheckboxLabel: React.FC = () => (
    <>
        {i18nBlock.checkboxLabel()}&nbsp;
        <Link target="_blank" url={LEGAL_LINK}>
            {i18nBlock.linkTitle()}
        </Link>
    </>
);

export interface IOfferFormProps extends IWithQaAttributes {
    isChecked: boolean;
    toggleChecked: () => void;
    buttonDisabled: boolean;
    onButtonClick: () => void;
}

const OfferForm: React.FC<IOfferFormProps> = ({
    isChecked,
    toggleChecked,
    buttonDisabled,
    onButtonClick,
    ...rest
}) => {
    const propsQa = getQa(rest);

    return (
        <>
            <Text tag="h1" weight="bold" size="xl" className={cx('header')}>
                {i18nBlock.title()}
            </Text>
            <Checkbox
                label={<CheckboxLabel />}
                checked={isChecked}
                onChange={toggleChecked}
                {...prepareQaAttributes({parent: propsQa, current: 'checkbox'})}
            />
            <Button
                theme="primary"
                size="l"
                width="max"
                className={cx('button')}
                disabled={buttonDisabled}
                onClick={onButtonClick}
                {...prepareQaAttributes({parent: propsQa, current: 'button'})}
            >
                {i18nBlock.agree()}
            </Button>
        </>
    );
};

export default OfferForm;
