import {IIconProps} from 'icons/types/icon';
import {MainAmenityIdType} from 'types/hotels/hotel/IHotel';

import AcIcon from 'icons/16/Ac';
import Glove from 'icons/16/Glove';
import WiFiIcon from 'icons/16/WiFi';
import CardIcon from 'icons/16/Card';
import BeachIcon from 'icons/16/Beach';
import ParkingIcon from 'icons/16/Parking';
import FitnessIcon from 'icons/16/Fitness';
import Sanitizers from 'icons/16/Sanitizers';
import Thermometer from 'icons/16/Thermometer';
import SocialDistance from 'icons/16/SocialDistance';
import SwimmingPoolIcon from 'icons/16/SwimmingPool';
import AirDisinfection from 'icons/16/AirDisinfection';

export function getIconByAmenityId(
    id: MainAmenityIdType,
): React.FC<IIconProps> | undefined {
    switch (id) {
        case MainAmenityIdType.WI_FI:
            return WiFiIcon;
        case MainAmenityIdType.POOL:
            return SwimmingPoolIcon;
        case MainAmenityIdType.CAR_PARK:
            return ParkingIcon;
        case MainAmenityIdType.AIR_CONDITIONING:
            return AcIcon;
        case MainAmenityIdType.GYM:
            return FitnessIcon;
        case MainAmenityIdType.PAYMENT_BY_CARD:
            return CardIcon;
        case MainAmenityIdType.BEACH_LINE:
            return BeachIcon;
        case MainAmenityIdType.AIR_DISINFECTION:
            return AirDisinfection;
        case MainAmenityIdType.SANITIZERS:
            return Sanitizers;
        case MainAmenityIdType.THERMOMETRY:
            return Thermometer;
        case MainAmenityIdType.PERSONAL_PROTECTIVE_GEAR:
            return Glove;
        case MainAmenityIdType.SAFETY_MARKING_FLOOR:
            return SocialDistance;
    }
}
