import {ComponentType} from 'react';

import {ERoomAmenityIcon} from 'types/hotels/offer/IHotelRoom';
import {IIconProps} from 'icons/types/icon';

import Bathroom from 'icons/16/Bathroom';
import AirConditioner from 'icons/16/AirConditioner';
import Balcony from 'icons/16/Balcony';
import Patio from 'icons/16/Patio';
import Shower from 'icons/16/Shower';
import CoffeeMachine from 'icons/16/CoffeeMachine';
import Multimedia from 'icons/16/Multimedia';
import MiniBar from 'icons/16/MiniBar';
import SmokingRoom from 'icons/16/SmokingRoom';
import Soundproof from 'icons/16/Soundproof';
import ViewOnSea from 'icons/16/ViewOnSea';
import ViewOnCity from 'icons/16/ViewOnCity';
import ViewOnGarden from 'icons/16/ViewOnGarden';
import ViewOnMountain from 'icons/16/ViewOnMountain';
import SwimmingPool from 'icons/16/SwimmingPool';
import ViewOnHippodrome from 'icons/16/ViewOnHippodrome';
import ViewOnStadium from 'icons/16/ViewOnStadium';
import WiFi from 'icons/16/WiFi';
import IncludeIcon from 'icons/16/Include';

const getRoomAmenityComponentIconById = (
    icon: ERoomAmenityIcon | string,
): ComponentType<IIconProps> => {
    switch (icon) {
        case ERoomAmenityIcon.AEROMASSAGE_BATH:
        case ERoomAmenityIcon.BATHTUB:
        case ERoomAmenityIcon.BATHTUB_ONLY:
        case ERoomAmenityIcon.DEEP_SOAKING_BATHTUB:
        case ERoomAmenityIcon.JETTED_BATHTUB:
        case ERoomAmenityIcon.PRIVATE_SPA_TUB:
        case ERoomAmenityIcon.PRIVATE_SPA_TUB_INDOOR:
        case ERoomAmenityIcon.SPRING_WATER_BATHTUB: {
            return Bathroom;
        }

        case ERoomAmenityIcon.AIR_CONDITIONING: {
            return AirConditioner;
        }

        case ERoomAmenityIcon.BALCONY:
        case ERoomAmenityIcon.BALCONY_OR_PATIO:
        case ERoomAmenityIcon.BALCONY_WITH_DECK_CHAIRS:
        case ERoomAmenityIcon.BALCONY_WITH_SIDE_SEA_VIEW:
        case ERoomAmenityIcon.BALCONY_WITH_VIEW:
        case ERoomAmenityIcon.FURNISHED_BALCONY:
        case ERoomAmenityIcon.FURNISHED_BALCONY_OR_PATIO: {
            return Balcony;
        }

        case ERoomAmenityIcon.BARBECUE_FACILITIES:
        case ERoomAmenityIcon.DECK_OR_PATIO:
        case ERoomAmenityIcon.FURNISHED_LANAI:
        case ERoomAmenityIcon.FURNISHED_PATIO:
        case ERoomAmenityIcon.LANAI:
        case ERoomAmenityIcon.PATIO: {
            return Patio;
        }

        case ERoomAmenityIcon.BATHROOM:
        case ERoomAmenityIcon.JACUZZI_BATHROOM:
        case ERoomAmenityIcon.PARTIALLY_OPEN_BATHROOM:
        case ERoomAmenityIcon.PRIVATE_BATHROOM:
        case ERoomAmenityIcon.PRIVATE_BATHROOM_NOT_IN_ROOM:
        case ERoomAmenityIcon.SECOND_BATHROOM: {
            return Shower;
        }

        case ERoomAmenityIcon.COFFEE_MACHINE: {
            return CoffeeMachine;
        }

        case ERoomAmenityIcon.FLAT_PANEL_TV:
        case ERoomAmenityIcon.HDTV:
        case ERoomAmenityIcon.LCD_TV:
        case ERoomAmenityIcon.LED_TV:
        case ERoomAmenityIcon.PLASMA_TV:
        case ERoomAmenityIcon.TELEVISION_SURCHARGE:
        case ERoomAmenityIcon.TELEVISION_YES:
        case ERoomAmenityIcon.THREE_TV_SETS: {
            return Multimedia;
        }

        case ERoomAmenityIcon.MINIBAR:
        case ERoomAmenityIcon.MINIBAR_STOCKED_FREE_ITEMS:
        case ERoomAmenityIcon.MINIBAR_STOCKED_SOME_FREE_ITEMS: {
            return MiniBar;
        }

        case ERoomAmenityIcon.SMOKING: {
            return SmokingRoom;
        }

        case ERoomAmenityIcon.SOUNDPROOFED_ROOMS: {
            return Soundproof;
        }

        case ERoomAmenityIcon.VIEW_BAY_VIEW:
        case ERoomAmenityIcon.VIEW_LAKE_VIEW:
        case ERoomAmenityIcon.VIEW_PARTIAL_SEAVIEW:
        case ERoomAmenityIcon.VIEW_RIVER_VIEW:
        case ERoomAmenityIcon.VIEW_SEA_VIEW: {
            return ViewOnSea;
        }

        case ERoomAmenityIcon.VIEW_CITY_VIEW: {
            return ViewOnCity;
        }

        case ERoomAmenityIcon.VIEW_COURT_VIEW:
        case ERoomAmenityIcon.VIEW_FOREST_VIEW:
        case ERoomAmenityIcon.VIEW_GARDEN_VIEW:
        case ERoomAmenityIcon.VIEW_PARK_VIEW: {
            return ViewOnGarden;
        }

        case ERoomAmenityIcon.VIEW_MOUNTAIN_VIEW: {
            return ViewOnMountain;
        }

        case ERoomAmenityIcon.WIFI: {
            return WiFi;
        }

        case ERoomAmenityIcon.PRIVATE_PLUNGE_POOL:
        case ERoomAmenityIcon.PRIVATE_POOL:
        case ERoomAmenityIcon.VIEW_POOL_VIEW: {
            return SwimmingPool;
        }

        case ERoomAmenityIcon.VIEW_VIEW_RACE_TRACK: {
            return ViewOnHippodrome;
        }

        case ERoomAmenityIcon.VIEW_VIEW_TO_STADIUM: {
            return ViewOnStadium;
        }

        default: {
            return IncludeIcon;
        }
    }
};

export default getRoomAmenityComponentIconById;
