import {
    IBasicFilterGroup,
    TActiveFilterAtomsType,
} from 'types/hotels/search/IFiltersInfo';

export const calculateTotalFilterGroups = (
    detailedFilters?: IBasicFilterGroup[],
    activeFilterAtoms?: TActiveFilterAtomsType,
): number => {
    if (activeFilterAtoms && detailedFilters && detailedFilters.length) {
        return detailedFilters.reduce(
            (total: number, filterGroup) =>
                filterGroup.items.reduce((groupTotal: number, filter) => {
                    const {atoms} = filter;

                    if (
                        atoms.length &&
                        atoms.every(atom => activeFilterAtoms[atom])
                    ) {
                        return groupTotal + 1;
                    }

                    return groupTotal;
                }, total),
            0,
        );
    }

    return 0;
};
