import {IRangePriceFilter} from 'types/hotels/search/IFiltersInfo';

export const calculateTotalPriceFilter = (
    priceFilter?: IRangePriceFilter,
): number => {
    if (priceFilter) {
        const {minValue, maxValue, minPriceEstimate, maxPriceEstimate} =
            priceFilter;

        if (minValue !== minPriceEstimate || maxValue !== maxPriceEstimate) {
            return 1;
        }
    }

    return 0;
};
