import {DAY} from 'utilities/dateUtils/constants';

import {TCollapsedFilters} from 'types/hotels/search/IFiltersInfo';

import {StorageSaverWithExpiration} from 'utilities/localStorage/StorageSaverWithExpiration';

const EXPIRATION_TIME = 14 * DAY;

class CollapsedFiltersSaver {
    private readonly storageSaver: StorageSaverWithExpiration<TCollapsedFilters>;

    constructor() {
        this.storageSaver = new StorageSaverWithExpiration(
            'hotels-collapsed-filters',
            EXPIRATION_TIME,
        );
    }

    getFromStorage(): TCollapsedFilters {
        return this.storageSaver.read() ?? {};
    }

    saveToStorage(collapsedFilters: TCollapsedFilters): void {
        this.storageSaver.save(collapsedFilters);
    }
}

export default new CollapsedFiltersSaver();
