import {flatten} from 'lodash';

import {
    IDetailedFiltersBatch,
    IBasicFilterGroup,
} from 'types/hotels/search/IFiltersInfo';

export function flatHotelFilters(
    batchedFilters?: IDetailedFiltersBatch[],
): IBasicFilterGroup[] {
    if (!batchedFilters) {
        return [];
    }

    return flatten(
        batchedFilters.map(({items}) =>
            items.reduce((columnItems, item) => {
                if (item.type === 'GROUP' && item.detailedFilters) {
                    columnItems.push(item.detailedFilters);
                }

                return columnItems;
            }, [] as IBasicFilterGroup[]),
        ),
    );
}
