import {
    IBasicFilterGroup,
    TActiveFilterAtomsType,
} from 'types/hotels/search/IFiltersInfo';

const getActiveAtomsForGroup = (
    group: IBasicFilterGroup,
    activeAtoms: TActiveFilterAtomsType,
): string[] => {
    const flatItems = group.items.map(item => item.atoms).flat();

    return flatItems.filter(atom => activeAtoms[atom]);
};

export default getActiveAtomsForGroup;
