import {ParsedQuery} from 'query-string';
import camelcaseKeys from 'camelcase-keys';

import {
    ISearchDebugQueryParams,
    ISearchPollingParams,
} from 'types/hotels/common/IQueryParams';
import {ISearchDebugParams} from 'types/hotels/common/IAttribution';
import {IUtmQueryParams} from 'types/common/IQueryParams';

import {getQueryByBrowserHistory} from 'utilities/getQueryByBrowserHistory/getQueryByBrowserHistory';
import {getUtmQueryParamsByBrowserHistory} from 'utilities/getUtmQueryParams/getUtmQueryParams';

export const getDebugQueryParamsByQuery = (
    queryByLocation: ParsedQuery,
): ISearchDebugQueryParams => {
    const {debugUseProdOffers} = queryByLocation;

    return {
        debugUseProdOffers: debugUseProdOffers
            ? Boolean(debugUseProdOffers)
            : undefined,
    };
};

export const getSearchPagePollingIdByQuery = (
    queryByLocation: ParsedQuery,
): ISearchPollingParams => {
    const {searchPagePollingId} = queryByLocation;

    return {
        searchPagePollingId: searchPagePollingId
            ? String(searchPagePollingId)
            : undefined,
    };
};

export const getMetaAndDebugQueryParams = (
    queryParams?: ParsedQuery,
): ISearchDebugQueryParams => {
    const queryByLocation = queryParams
        ? queryParams
        : getQueryByBrowserHistory();

    return {
        ...getDebugQueryParamsByQuery(queryByLocation),
        ...getSearchPagePollingIdByQuery(queryByLocation),
    };
};

export const getMetaAndDebugParams = (
    queryParams?: ParsedQuery,
): ISearchDebugParams => {
    const metaAndDebugQueryParams = getMetaAndDebugQueryParams(queryParams);

    return camelcaseKeys(metaAndDebugQueryParams) as ISearchDebugParams;
};

export const getAttributionParams = (
    queryParams?: ParsedQuery,
): ISearchDebugParams => {
    return getMetaAndDebugParams(queryParams);
};

export const getAttributionQueryParams = (
    queryParams?: ParsedQuery,
): ISearchDebugParams & IUtmQueryParams => {
    return {
        ...getMetaAndDebugQueryParams(queryParams),
        ...getUtmQueryParamsByBrowserHistory(),
    };
};
