import {
    EHotelBadgeType,
    IHotelOrOfferBadge,
} from 'types/hotels/offer/IHotelOffer';

import * as i18nBlock from 'i18n/hotels-HotelOfferBadge';

export function getWelcomePromocodeBadge(
    badges: IHotelOrOfferBadge[] | null | undefined,
    options: {hasFirstPromocode?: boolean},
): IHotelOrOfferBadge | undefined {
    const {hasFirstPromocode} = options;

    return hasFirstPromocode &&
        badges?.find(badge => badge.id === EHotelBadgeType.WELCOME_PROMOCODE)
        ? {
              id: EHotelBadgeType.WELCOME_PROMOCODE,
              text: i18nBlock.welcomePromocode(),
          }
        : undefined;
}
