import moment from 'moment';

import {
    IBookHotelInfo,
    IBookSearchParams,
} from 'server/api/HotelsBookAPI/types/IBookOffer';

import {getTotalNights} from 'projects/hotels/utilities/calculateTotalNights/calculateTotalNights';

import * as i18nBlock from 'i18n/hotels-HotelCheckDates';

export const prepareSearchDate = (date: string): string =>
    moment(date).format('D MMMM, ddd');

interface IPreparedCheckinCheckoutTime {
    checkinText: string;
    checkoutText: string;
}

export const prepareCheckinCheckoutTime = ({
    checkin: {beginTime: checkinBeginTime, endTime: checkinEndTime},
    checkout: {endTime: checkoutEndTime},
}: Pick<
    IBookHotelInfo,
    'checkin' | 'checkout'
>): IPreparedCheckinCheckoutTime => {
    const preparedCheckinBeginTime = checkinBeginTime
        ? checkinBeginTime
        : false;
    const preparedCheckinEndTime = checkinEndTime ? checkinEndTime : false;
    const preparedCheckoutEndTime = checkoutEndTime ? checkoutEndTime : false;

    const checkinText = i18nBlock.checkin({
        beginTime: preparedCheckinBeginTime,
        endTime: preparedCheckinEndTime,
    });
    const checkoutText = i18nBlock.checkout({
        endTime: preparedCheckoutEndTime,
    });

    return {checkinText, checkoutText};
};

interface IHotelCheckDates {
    checkinData: {
        title: string;
        value: string;
    };
    checkoutData: {
        title: string;
        value: string;
    };
    totalNights: number;
}

export default function getHotelCheckDates(
    checkParams: Pick<IBookHotelInfo, 'checkin' | 'checkout'> &
        Pick<IBookSearchParams, 'startDate' | 'endDate'>,
): IHotelCheckDates {
    const {checkin, checkout, endDate, startDate} = checkParams;

    const totalNights = getTotalNights(startDate, endDate);

    const {checkinText, checkoutText} = prepareCheckinCheckoutTime({
        checkin,
        checkout,
    });

    const preparedStartDate = `${prepareSearchDate(startDate)} ${checkinText}`;
    const preparedEndDate = `${prepareSearchDate(endDate)} ${checkoutText}`;

    return {
        checkinData: {
            title: i18nBlock.checkinDotTitle(),
            value: preparedStartDate,
        },
        checkoutData: {
            title: i18nBlock.checkoutDotTitle(),
            value: preparedEndDate,
        },
        totalNights,
    };
}
