import {
    HotelSlugType,
    IHotelIdentifier,
    PermalinkType,
} from 'types/hotels/hotel/IHotel';
import {ReactRouterMatchType} from 'types/common/IReactRouterLocation';
import {IHotelSlugRouteMatch} from 'types/hotels/hotel/IHotelSlugRouteMatch';

export const getHotelSlugByParams = ({
    regionSlug,
    hotelSlug,
}: {
    regionSlug: string;
    hotelSlug: string;
}): HotelSlugType => `${regionSlug}/${hotelSlug}`;

export const getHotelSlugByRouteMatch = (
    match: ReactRouterMatchType<IHotelSlugRouteMatch>,
): HotelSlugType | undefined => {
    const {
        params: {regionSlug, hotelSlug},
    } = match;

    if (regionSlug && hotelSlug) {
        return getHotelSlugByParams({regionSlug, hotelSlug});
    }
};

export const getHotelIdentifier = ({
    hotelPermalink,
    regionSlug,
    hotelSlug,
}: {
    hotelPermalink?: PermalinkType;
    regionSlug?: string;
    hotelSlug?: string;
}): IHotelIdentifier | undefined => {
    if (regionSlug && hotelSlug) {
        return {
            hotelSlug: getHotelSlugByParams({regionSlug, hotelSlug}),
        };
    }

    if (hotelPermalink) {
        return {
            permalink: hotelPermalink,
        };
    }
};
