import {ParsedQuery} from 'query-string';

import {
    MAIN_TAB_IMAGES_LIMIT,
    MAIN_TAB_SIMILAR_HOTELS_LIMIT,
} from 'projects/hotels/constants/hotelPage';
import {DEFAULT_TEXT_REVIEW_QUANTITATIVE} from 'projects/hotels/constants/reviews';

import {IHotelInfoRequestParams} from 'server/api/HotelSearchAPI/types/IHotelInfo';

import {
    validateSearchHotelsAdultsParam,
    validateSearchHotelsParams,
} from 'projects/hotels/utilities/validateSearchHotelsParams/validateSearchHotelsParams';
import {getHotelIdentifier} from 'projects/hotels/utilities/getHotelIdentifier/getHotelIdentifier';

import {
    getOfferAttributionParamsByLocation,
    getHotelOfferToken,
} from './getOfferAttributionParamsByLocation';

export const getHotelInfoSearchParamsByLocation = ({
    queryParams,
    hotelSlug,
    regionSlug,
}: {
    queryParams: ParsedQuery;
    hotelSlug?: string;
    regionSlug?: string;
}): IHotelInfoRequestParams => {
    const {
        hotelPermalink,
        checkinDate,
        checkoutDate,
        childrenAges,
        adults,
        searchPagePollingId,
        useDefaultSearchParams,
    } = validateSearchHotelsParams(queryParams);

    return {
        adults: validateSearchHotelsAdultsParam(
            adults,
            checkinDate,
            checkoutDate,
        ),
        childrenAges,
        checkinDate,
        checkoutDate,
        searchPagePollingId,
        useDefaultSearchParams,
        domain: 'ru',
        similarHotelLimit: MAIN_TAB_SIMILAR_HOTELS_LIMIT,
        imageLimit: MAIN_TAB_IMAGES_LIMIT,
        ...DEFAULT_TEXT_REVIEW_QUANTITATIVE,
        ...getHotelIdentifier({hotelPermalink, hotelSlug, regionSlug}),
        ...getHotelOfferToken(queryParams),
        ...getOfferAttributionParamsByLocation(queryParams),
    };
};
