import {ParsedQuery} from 'query-string';

import {
    IHotelPageOfferQueryParams,
    IViewModePageQueryParams,
} from 'types/hotels/common/IQueryParams';

import {
    filterQueryByParamList,
    checkQueryStringParam,
} from 'utilities/location/filterQueryByParamList';
import {getQueryByBrowserHistory} from 'utilities/getQueryByBrowserHistory/getQueryByBrowserHistory';

const HOTEL_PAGE_OFFER_QUERY_PARAMS: (keyof IHotelPageOfferQueryParams)[] = [
    'token',
    'label',
];

/* Filter query params */

/** Фильтрует query параметры для предложения */
export const filterHotelPageOfferParams = filterQueryByParamList<
    IHotelPageOfferQueryParams,
    ParsedQuery
>(HOTEL_PAGE_OFFER_QUERY_PARAMS, checkQueryStringParam);

/* Get params */

export function getViewModePageParamsByQuery(
    queryParams?: ParsedQuery,
): IViewModePageQueryParams {
    const {isHeadless} = queryParams ?? getQueryByBrowserHistory();

    return {
        isHeadless: isHeadless ? Boolean(isHeadless) : undefined,
    };
}
