import {ParsedQuery} from 'query-string';

import {
    IHotelPageAttributionQueryParams,
    IHotelPageTokenQueryParams,
} from 'types/hotels/common/IQueryParams';
import {
    EPortalSeedReferer,
    ISearchDebugParams,
} from 'types/hotels/common/IAttribution';

import {getAttributionParams} from 'projects/hotels/utilities/getAttributionParams/getAttributionParams';
import {getQueryByBrowserHistory} from 'utilities/getQueryByBrowserHistory/getQueryByBrowserHistory';

export const getHotelOfferToken = (
    queryParams?: ParsedQuery,
): IHotelPageTokenQueryParams => {
    const {token} = queryParams ? queryParams : getQueryByBrowserHistory();

    return {
        token: token ? String(token) : undefined,
    };
};

export const getOfferAttributionParams = (
    queryParams?: ParsedQuery,
): IHotelPageAttributionQueryParams => {
    const {label, seed} = queryParams
        ? queryParams
        : getQueryByBrowserHistory();

    return {
        label: label ? String(label) : undefined,
        seed: seed ? (String(seed) as EPortalSeedReferer) : undefined,
    };
};

export const getOfferAttributionParamsByLocation = (
    queryParams?: ParsedQuery,
): IHotelPageAttributionQueryParams & ISearchDebugParams => {
    return {
        ...getOfferAttributionParams(queryParams),
        ...getAttributionParams(queryParams),
    };
};
