import {IRequiredOfferParams} from 'types/hotels/offer/IHotelOffer';

import {validateSearchHotelsParams} from 'projects/hotels/utilities/validateSearchHotelsParams/validateSearchHotelsParams';
import {getQueryByBrowserHistory} from 'utilities/getQueryByBrowserHistory/getQueryByBrowserHistory';

export const getOfferRequiredSearchParamsByLocation = ():
    | IRequiredOfferParams
    | undefined => {
    const queryParams = getQueryByBrowserHistory();
    const {checkinDate, checkoutDate, childrenAges, adults} =
        validateSearchHotelsParams(queryParams);

    if (checkinDate && checkoutDate) {
        return {
            checkinDate,
            checkoutDate,
            childrenAges,
            adults,
        };
    }
};
