import {
    EDownloadActionTypes,
    ESearchByOrderId,
} from 'server/api/HotelsBookAPI/types/IDownloadVoucher';

import {internalUrl} from 'utilities/url';

export interface IVoucherUrlParams {
    actionType: EDownloadActionTypes;
    searchBy: ESearchByOrderId;
}

/* Get url for print or download hotels order voucher */
export function getHotelsVoucherUrl(
    orderId: string,
    params: IVoucherUrlParams,
): string {
    return internalUrl(`/download/hotels/voucher/${orderId}`, params);
}
