import {IBookImage} from 'server/api/HotelsBookAPI/types/IBookOffer';

export const getImagesBySize = (
    images: IBookImage[],
    imageSizeName: string,
): {src: string}[] =>
    images.map(image => {
        let imageSrc = image.links[imageSizeName]?.href;

        if (!imageSrc) {
            imageSrc = Object.values(image.links)[0]?.href;
        }

        return {
            src: imageSrc,
        };
    });
