import moment from 'moment-timezone';

import {IBookOfferRefundableRule} from 'server/api/HotelsBookAPI/types/IBookOffer';
import EBookOfferRefundableType from 'projects/account/pages/Order/types/EBookOfferRefundableType';

import {MOSCOW_TIME_ZONE} from 'utilities/dateUtils/timezones';
import {HUMAN_DATETIME} from 'utilities/dateUtils/formats';

import * as i18nBlock from 'i18n/hotels-OfferRefundableRules';

export const GREEN_COLOR_THEME = 'green';
export const RED_COLOR_THEME = 'red';
export const DEFAULT_COLOR_THEME = 'default';

export const prepareRefundableDate = (
    date: string,
    format: string = HUMAN_DATETIME,
) => moment.utc(date).tz(MOSCOW_TIME_ZONE).format(format);

export const getRefundableRuleRenderProps = (
    refundableRule: IBookOfferRefundableRule,
) => {
    const {
        type,
        endDate,
        startDate,
        price: {amount, currency},
    } = refundableRule;

    let title = '';
    let date = '';
    let price;
    let theme = DEFAULT_COLOR_THEME;

    switch (type) {
        case EBookOfferRefundableType.NO_PENALTY: {
            title = i18nBlock.freeRuleTitle();
            date = i18nBlock.freeRuleDate({
                date: prepareRefundableDate(endDate),
            });
            theme = GREEN_COLOR_THEME;

            break;
        }

        case EBookOfferRefundableType.SOME_PENALTY: {
            title = i18nBlock.somePriceRuleTitle();
            price = {
                amount,
                currency,
            };

            if (startDate && endDate) {
                date = i18nBlock.somePriceRuleDate({
                    startDate: prepareRefundableDate(startDate),
                    endDate: prepareRefundableDate(endDate),
                });
            } else {
                date = i18nBlock.somePriceOpenRuleDate({
                    endDate: prepareRefundableDate(endDate),
                });
            }

            break;
        }

        case EBookOfferRefundableType.FULL_PRICE: {
            title = i18nBlock.fullPriceRuleTitle();
            date = i18nBlock.fullPriceRuleDate({
                date: prepareRefundableDate(startDate),
            });

            theme = RED_COLOR_THEME;

            break;
        }
    }

    return {
        title,
        theme,
        date,
        price,
    };
};
