/* ChildrenAges */
import {IRequiredOfferParams} from 'types/hotels/offer/IHotelOffer';
import {IBaseSearchQueryParams} from 'types/hotels/common/IQueryParams';

export const getChildrenAgesQueryParam = (
    childrenAges?: number[],
): string | undefined => {
    if (childrenAges) {
        return childrenAges.join(',');
    }
};

/* OfferSearchParams */
export const getOfferSearchQueryParams = (
    offerSearchParams?: IRequiredOfferParams,
): IBaseSearchQueryParams | undefined => {
    if (offerSearchParams) {
        const {adults, checkoutDate, childrenAges, checkinDate} =
            offerSearchParams;

        return {
            adults,
            checkinDate,
            checkoutDate,
            childrenAges: getChildrenAgesQueryParam(childrenAges),
        };
    }
};
