import _isEmpty from 'lodash/isEmpty';

import {IFullFilters, IFilterParams} from 'types/hotels/search/IFiltersInfo';

export const getFilterParams = (filters: IFullFilters): IFilterParams => {
    const {priceFilter, activeFilterAtoms, geoIdFilter} = filters;

    const filterPriceFrom =
        priceFilter && priceFilter.minValue !== priceFilter.minPriceEstimate
            ? priceFilter.minValue
            : undefined;
    const filterPriceTo =
        priceFilter && priceFilter.maxValue !== priceFilter.maxPriceEstimate
            ? priceFilter.maxValue
            : undefined;
    const filterAtoms = _isEmpty(activeFilterAtoms)
        ? undefined
        : Object.keys(activeFilterAtoms);

    const onlyCurrentGeoId = geoIdFilter?.selected ?? undefined;

    return {
        filterAtoms,
        filterPriceTo,
        filterPriceFrom,
        onlyCurrentGeoId,
    };
};
