import {
    ISearchPageQueryFilterParams,
    ISearchPageQueryParams,
} from 'types/hotels/common/IQueryParams';

import {getQueryByBrowserHistory} from 'utilities/getQueryByBrowserHistory/getQueryByBrowserHistory';

export const getSearchPageFilterQueryParamsByLocation =
    (): ISearchPageQueryFilterParams => {
        const queryByLocation = getQueryByBrowserHistory();
        const {filterAtoms, minPrice, maxPrice, onlyCurrentGeoId} =
            queryByLocation as ISearchPageQueryParams;

        return {
            filterAtoms,
            minPrice,
            maxPrice,
            onlyCurrentGeoId,
        };
    };
