import {
    ISearchPageGeoQueryParams,
    ISearchPageQueryFilterParams,
    ISearchPageQueryParams,
    ISearchPageSortQueryParams,
} from 'types/hotels/common/IQueryParams';
import {IFilterParams} from 'types/hotels/search/IFiltersInfo';
import {TSortId} from 'types/hotels/search/ISortInfo';
import {ISearchPageIdentifyParams} from 'types/hotels/geoRegion/IGeoRegionInfo';
import {GeoIdType} from 'types/hotels/hotel/IGeoRegion';

import {getUtmQueryParamsByBrowserHistory} from 'utilities/getUtmQueryParams/getUtmQueryParams';

/* Filters */
export const getFilterQueryParams = (
    filterParams?: IFilterParams,
): Partial<ISearchPageQueryFilterParams> => {
    const filterQueryParams: Partial<ISearchPageQueryFilterParams> = {};

    if (filterParams) {
        const {filterAtoms, filterPriceFrom, filterPriceTo, onlyCurrentGeoId} =
            filterParams;

        if (filterAtoms?.length) {
            filterQueryParams.filterAtoms = filterAtoms.join(',');
        }

        if (filterPriceFrom) {
            filterQueryParams.minPrice = filterPriceFrom;
        }

        if (filterPriceTo) {
            filterQueryParams.maxPrice = filterPriceTo;
        }

        if (typeof onlyCurrentGeoId !== 'undefined') {
            filterQueryParams.onlyCurrentGeoId = Number(onlyCurrentGeoId);
        }
    }

    return filterQueryParams;
};

/* Sort */
export const getSortQueryParams = (
    selectedSortId?: TSortId,
): ISearchPageSortQueryParams | undefined => {
    if (selectedSortId) {
        return {
            selectedSortId,
        };
    }

    return undefined;
};

/* GeoRegion */
export const getGeoQueryParams = (
    geoId?: GeoIdType,
): ISearchPageGeoQueryParams | undefined => {
    if (geoId) {
        return {
            geoId,
        };
    }

    return undefined;
};

/* Main */
export const getSearchPageQueryByGeoRegionInfo = ({
    filterParams,
    selectedSortId,
    geoId,
}: ISearchPageIdentifyParams): ISearchPageQueryParams => {
    const filterQuery = getFilterQueryParams(filterParams);
    const sortQuery = getSortQueryParams(selectedSortId);
    const geoSearchQuery = getGeoQueryParams(geoId);
    const utmQueryParams = getUtmQueryParamsByBrowserHistory();

    return {
        ...utmQueryParams,
        ...filterQuery,
        ...sortQuery,
        ...geoSearchQuery,
    };
};
