import {EHotelsGoal} from 'utilities/metrika/types/goals/hotels';

const getHotelsGeolocationSuggestMetrika = (): EHotelsGoal => {
    const path = window.location.pathname;

    switch (true) {
        //indexPage
        case /\/hotels\/?$/i.test(path):
            return EHotelsGoal.MC_HOTELS_INDEX_PAGE_SUGGEST_HOTELSNEARBY;

        //searchPage
        case /\/hotels\/search\/?$/i.test(path):
            return EHotelsGoal.MC_HOTELS_SEARCH_PAGE_SUGGEST_HOTELSNEARBY;

        //hotelPage
        case /\/hotels\/.*\/.{1,}$/i.test(path):
            return EHotelsGoal.MC_HOTELS_HOTEL_PAGE_SUGGEST_HOTELSNEARBY;

        //regionPage
        case /\/hotels\/.*$/i.test(path):
            return EHotelsGoal.MC_HOTELS_REGION_PAGE_SUGGEST_HOTELSNEARBY;

        default:
            return EHotelsGoal.MC_HOTELS_SEARCH_PAGE_SUGGEST_HOTELSNEARBY;
    }
};

export default getHotelsGeolocationSuggestMetrika;
