import {EColorZone} from 'types/hotels/search/EColorZone';

import {params} from 'utilities/metrika';

import getColorFromRequestsTime from '../getColorFromRequestsTime/getColorFromRequestsTime';

interface ISendMetrikaSearchRequestsTimes {
    requestsTimeSumBackend: number;
    requestsTimeSumFrontend: number | null;
}

interface IMetrikaSearchRequestsTimes {
    hotels: {
        searchPage: {
            requestsTimeSumBack: Partial<Record<EColorZone, number>>;
            requestsTimeSumFront?: Partial<Record<EColorZone, number>>;
        };
    };
}

export default function sendMetrikaSearchRequestsTimes({
    requestsTimeSumBackend,
    requestsTimeSumFrontend,
}: ISendMetrikaSearchRequestsTimes): void {
    const backendRequestsTimeZone = getColorFromRequestsTime(
        requestsTimeSumBackend,
    );
    const metrikaSearchRequestsTimes: IMetrikaSearchRequestsTimes = {
        hotels: {
            searchPage: {requestsTimeSumBack: {[backendRequestsTimeZone]: 1}},
        },
    };

    if (requestsTimeSumFrontend) {
        const frontendRequestsTimeZone = getColorFromRequestsTime(
            requestsTimeSumFrontend,
        );

        metrikaSearchRequestsTimes.hotels.searchPage = {
            ...metrikaSearchRequestsTimes.hotels.searchPage,
            requestsTimeSumFront: {[frontendRequestsTimeZone]: 1},
        };
    }

    params(metrikaSearchRequestsTimes);
}
