import {IHotelsPreviousSearch} from 'types/hotels/previousSearches/IPreviousSearch';

import humanizePeriod, {humanizeDate} from 'utilities/dateUtils/humanizePeriod';

export default function getPreviousSearchDateDescription(
    item: IHotelsPreviousSearch,
): string | null {
    if (item.startDate) {
        if (item.endDate) {
            return humanizePeriod(item.startDate, item.endDate, {
                short: true,
                checkSameDate: false,
                checkAnotherEndYear: false,
            });
        }

        return humanizeDate(item.startDate);
    }

    return null;
}
