import {PRODUCTION_PROJECT_URL} from 'constants/common';
import {URLs} from 'constants/urls';

import {internalUrl} from 'utilities/url';

interface IHotelPageParams {
    slug?: string;
    permalink?: string;
}

export function getAbsoluteHotelUrl(
    params: IHotelPageParams,
): string | undefined {
    const url = getRelativeHotelUrl(params);

    if (url) {
        return `${PRODUCTION_PROJECT_URL}${url}`;
    }

    return undefined;
}

function getRelativeHotelUrl({
    slug,
    permalink,
}: IHotelPageParams): string | undefined {
    if (typeof slug === 'string') {
        return internalUrl(`${URLs.hotels}/${slug}`);
    }

    if (permalink) {
        return internalUrl(URLs.hotelsHotelPage, {
            permalink,
        });
    }

    return undefined;
}
