import {ParsedQuery} from 'query-string';

import {URLs} from 'constants/urls';
import {PRODUCTION_PROJECT_URL} from 'constants/common';

import {DateType} from 'types/hotels/common/IDate';
import {ReactRouterLocationType} from 'types/common/IReactRouterLocation';

import getQueryByLocation from 'utilities/getQueryByLocation/getQueryByLocation';
import {getAttributionQueryParams} from 'projects/hotels/utilities/getAttributionParams/getAttributionParams';
import {internalUrl} from 'utilities/url';
import {getStoredSrcQueryParams} from 'utilities/srcParams/srcParams';

export interface IHotelsSearchParams {
    adults: number;
    childrenAges?: number[];
    checkinDate?: DateType;
    checkoutDate?: DateType;
}

export function getHotelsSearchUrl(
    location: ReactRouterLocationType,
    geoId: number,
): string {
    const queryByLocation = getQueryByLocation(location);
    const {checkinDate, checkoutDate, adults, childrenAges} = queryByLocation;

    return internalUrl(URLs.hotelsSearch, {
        geoId,
        checkinDate,
        checkoutDate,
        adults,
        childrenAges,
        ...getStoredSrcQueryParams(),
        ...getAttributionQueryParams(queryByLocation),
    });
}

export function getHotelsSearchUrlByParams(
    geoId: number,
    params: IHotelsSearchParams,
    queryByLocation?: ParsedQuery,
): string {
    return internalUrl(URLs.hotelsSearch, {
        geoId,
        ...params,
        ...getStoredSrcQueryParams(),
        ...getAttributionQueryParams(queryByLocation),
    });
}

export function getShareHotelsSearchUrl(
    location: ReactRouterLocationType,
): string {
    const queryByLocation = getQueryByLocation(location);
    const {checkinDate, checkoutDate, adults, childrenAges} = queryByLocation;

    return `${PRODUCTION_PROJECT_URL}${internalUrl(URLs.hotelsSearch, {
        checkinDate,
        checkoutDate,
        adults,
        childrenAges,
    })}`;
}
