import {FunctionComponent} from 'react';
import {Route, Switch} from 'react-router-dom';
import {useSelector} from 'react-redux';

import {URLs} from 'constants/urls';

import {ELoadableReducer} from 'types/common/ELoadableReducer';
import EAsyncStatus from 'types/common/EAsyncStatus';

import hotelsExtranetRootReducer from 'reducers/hotelsExtranet/rootReducer';

import {approveHotelSelector} from 'selectors/hotelsExtranet/approveHotelSelector';

import useApproveHotel from '../utilities/useApproveHotel';
import useHotelsList from '../utilities/useHotelsList';
import {useQueryByLocation} from 'utilities/hooks/useQueryByLocation';

import withReducers from 'containers/withReducers/withReducers';

import NotFoundPage from 'components/NotFound/NotFoundPage/NotFoundPage';

import IndexPage from '../pages/IndexPage/IndexPage';
import OrdersPage from '../pages/OrdersPage/OrdersPage';
import PaymentsPage from '../pages/PaymentsPage/PaymentsPage';
import AddHotelPage from '../pages/AddHotelPage/AddHotelPage';

const HotelsExtranetApp: FunctionComponent = () => {
    const {approveToken} = useQueryByLocation();

    const approveRequest = useSelector(approveHotelSelector);

    useApproveHotel();
    useHotelsList(
        !approveToken ||
            approveRequest.status === EAsyncStatus.SUCCESS ||
            approveRequest.status === EAsyncStatus.ERROR,
        !approveToken,
    );

    return (
        <Switch>
            <Route
                path={URLs.hotelsExtranetAddHotelPage}
                component={AddHotelPage}
                exact
            />
            <Route
                path={[URLs.hotelsExtranetRoot, URLs.hotelsExtranetIndexPage]}
                component={IndexPage}
                exact
            />
            <Route
                path={URLs.hotelsExtranetOrdersPage}
                component={OrdersPage}
            />
            <Route
                path={URLs.hotelsExtranetPaymentsPage}
                component={PaymentsPage}
            />
            <Route component={NotFoundPage} />
        </Switch>
    );
};

export default withReducers([
    [ELoadableReducer.HOTELS_EXTRANET, hotelsExtranetRootReducer],
])(HotelsExtranetApp);
