import {ComponentType, FunctionComponent, ReactNode} from 'react';

import {IWithClassName} from 'types/withClassName';

import Flex from 'components/Flex/Flex';
import Heading from 'components/Heading/Heading';
import Text from 'components/Text/Text';

import HotelsExtranetLayout from '../HotelsExtranetLayout/HotelsExtranetLayout';

import cx from './AddHotelResultPage.scss';

interface IAddHotelResultPageProps {
    ImageComponent: ComponentType<IWithClassName>;
    title: string;
    text?: string;
    button?: ReactNode;
}

const AddHotelResultPage: FunctionComponent<IAddHotelResultPageProps> = ({
    ImageComponent,
    title,
    text,
    button,
}) => {
    return (
        <HotelsExtranetLayout contentClassName={cx('layout')}>
            <Flex
                className={cx('root')}
                flexDirection="column"
                alignItems="center"
                between={3}
            >
                <ImageComponent className={cx('image')} />
                <Heading level="2" className={cx('title')}>
                    {title}
                </Heading>
                {text && <Text align="center">{text}</Text>}
                {button}
            </Flex>
        </HotelsExtranetLayout>
    );
};

export default AddHotelResultPage;
