import {FC, useRef} from 'react';

import EPopupDirection from 'components/Popup/types/EPopupDirection';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18n/hotelsExtranet';

import BaseDatePicker from 'components/DatePicker/DatePickerNew';
import MessageBoxPopup from 'components/MessageBoxPopup/MessageBoxPopup';
import Box from 'components/Box/Box';
import ArrowBottomIcon from 'icons/16/ArrowBottom';

import cx from './DatePicker.scss';

const MIN_YEAR = 2019;
const MIN_DATE = new Date(MIN_YEAR, 0, 1);

export const MAX_DATE = new Date(new Date().getFullYear() + 1, 11, 31);

interface IDatePickerProps {
    startDate: Date | null;
    endDate: Date | null;
    onShowCalendar: () => void;
    onDaySelect: (params: {
        startDate: Nullable<Date>;
        endDate: Nullable<Date>;
    }) => void;
    areDatesRequired: boolean;
}

const DatePicker: FC<IDatePickerProps> = ({
    startDate,
    endDate,
    onDaySelect,
    onShowCalendar,
    areDatesRequired,
}) => {
    const deviceType = useDeviceType();
    const datesRef = useRef<HTMLDivElement>(null);

    return (
        <div className={cx('datePickerWrap')} ref={datesRef}>
            <BaseDatePicker
                triggerClassName={cx('datePickerTrigger')}
                triggerValueClassName={cx('datePickerTriggerValue')}
                triggerPlaceholderClassName={cx('datePickerPlaceholderValue')}
                triggerIconClassName={cx('datePickerTriggerIcon')}
                triggerIcon={ArrowBottomIcon}
                minDate={MIN_DATE}
                maxDate={MAX_DATE}
                nowDate={new Date()}
                startDate={startDate}
                endDate={endDate}
                size="m"
                startDatePlaceholder=""
                canRenderResetIcon={false}
                cutPastWeeks
                isShortTriggerFormatDate
                triggerViewType="tile"
                triggerValue=""
                isModalView={false}
                deviceType={deviceType}
                onDaySelect={onDaySelect}
                onShowCalendar={onShowCalendar}
                hasEndDate
                canSelectRange
                resetRangeAfterFirstInteraction
                placeholder={i18nBlock.date()}
                withYearSelect
            />
            <MessageBoxPopup
                isVisible={areDatesRequired}
                anchorRef={datesRef}
                direction={EPopupDirection.BOTTOM}
            >
                <Box x={3} y={2}>
                    {i18nBlock.datesRequired()}
                </Box>
            </MessageBoxPopup>
        </div>
    );
};

export default DatePicker;
